/* Display options */

export const GRAPH_MODE_OPTIONS = [
  { value: 'GRAPH', title: 'Polyline' },
  { value: 'PIE', title: 'Pie' },
  { value: 'BARS', title: 'Bars' },
  { value: 'DISTRIBUTION', title: 'Distribution' },
  { value: 'HEATMAP', title: 'Heatmap' },
  { value: 'NONE', title: 'None' },
];

export const SECONDARY_GRAPH_MODE_OPTIONS = GRAPH_MODE_OPTIONS.filter((o) => o.value !== 'GRAPH');

export const COLOR_SCHEME_OPTIONS = [
  { value: 'AUTO', title: 'Auto' },
  { value: 'DEFAULT', title: 'Default' },
  { value: 'GRADIENT', title: 'Gradient' },
];

export const BOOL_OPTIONS = [
  { value: 'null', title: 'Default' },
  { value: 'true', title: 'On' },
  { value: 'false', title: 'Off' },
];

export const STACK_OPTIONS = BOOL_OPTIONS;
export const DROP_NANS_OPTIONS = BOOL_OPTIONS;

export const SCALE_OPTIONS = [
  { value: 'NATURAL', title: 'Natural' },
  { value: 'LOG', title: 'Logarithmic' },
];

export const AGGR_OPTIONS = [
  { value: 'AVG', title: 'Avg' },
  { value: 'MIN', title: 'Min' },
  { value: 'MAX', title: 'Max' },
  { value: 'LAST', title: 'Last' },
  { value: 'SUM', title: 'Sum' },
];

export const DOWNSAMPLING_AGGR_OPTIONS = [
  { value: 'DEFAULT', title: 'Default' },
  { value: 'AVG', title: 'Avg' },
  { value: 'MIN', title: 'Min' },
  { value: 'MAX', title: 'Max' },
  { value: 'LAST', title: 'Last' },
  { value: 'SUM', title: 'Sum' },
];

export const DOWNSAMPLING_FILL_OPTIONS = [
  { value: 'NULL', title: 'Null' },
  { value: 'NONE', title: 'None' },
  { value: 'PREVIOUS', title: 'Previous' },
];

export const INTERPOLATE_OPTIONS = [
  { value: 'LINEAR', title: 'Linear' },
  { value: 'LEFT', title: 'Left' },
  { value: 'RIGHT', title: 'Right' },
  { value: 'NONE', title: 'None' },
];

/* Transform options */

export const TRANSFORM_OPTIONS = [
  { value: 'NONE', title: 'None' },
  { value: 'DIFFERENTIATE', title: 'Differentiate (without negative)' },
  { value: 'DIFFERENTIATE_WITH_NEGATIVE', title: 'Differentiate (with negative)' },
  { value: 'INTEGRATE', title: 'Integrate' },
  { value: 'MOVING_AVERAGE', title: 'Moving average' },
  { value: 'MOVING_PERCENTILE', title: 'Moving percentile' },
  { value: 'DIFF', title: 'Diff between values' },
  { value: 'ASAP', title: 'Auto smoother' },
];

export const OVERLINE_TRANSFORM_OPTIONS = [
  { value: 'NONE', title: 'None' },
  { value: 'PERCENTILE', title: 'Percentile' },
  { value: 'WEIGHTED_PERCENTILE', title: 'Weighed percentile' },
  { value: 'SUMMARY', title: 'Summary' },
];

export const FILTER_OPTIONS = [
  { value: 'NONE', title: 'None' },
  { value: 'TOP', title: 'Top' },
  { value: 'BOTTOM', title: 'Bottom' },
];

export const DOWNSAMPLING_OPTIONS = [
  { value: 'AUTO', title: 'Auto' },
  { value: 'BY_INTERVAL', title: 'By interval' },
  { value: 'BY_POINTS', title: 'By points' },
  { value: 'OFF', title: 'Off' },
];

export const SORT_ORDER_OPTIONS = [
  { value: false, title: 'Ascending' },
  { value: true, title: 'Descending' },
];

export const checkModeHasYaxis = (mode) => {
  switch (mode) {
    case 'GRAPH':
    case 'BARS':
    case 'DISTRIBUTION':
      return true;
    default:
      return false;
  }
};
