import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import entries from 'lodash/entries';
import Tooltip from 'react-bootstrap/es/Tooltip';
import OverlayTrigger from 'react-bootstrap/es/OverlayTrigger';

class MetricsCountInfo extends PureComponent {
  render() {
    const { metricsCountByCluster } = this.props;

    let metricsCountInfo;

    const metricsCountList = entries(metricsCountByCluster);

    if (metricsCountList.length === 0) {
      metricsCountInfo = 'No metrics found';
    } else {
      const firstCount = metricsCountList[0][1];
      if (metricsCountList.every((count) => count[1] === firstCount)) {
        metricsCountInfo = `Metrics count: ${firstCount}`;
      } else {
        const maxMetricsCount = metricsCountList.reduce((a, b) => Math.max(a[1], b[1]));

        const tooltip = (
          <Tooltip id="metrics-count-by-cluster-tooltip">
            Metrics count:
            <ul>
              {metricsCountList.map((clusterAndCount) => (
                <li key={clusterAndCount[0]}>
                  {clusterAndCount[0]}
                  {' '}
                  -
                  {' '}
                  {clusterAndCount[1]}
                </li>
              ))}
            </ul>
          </Tooltip>
        );

        const tooltipButton = (
          <OverlayTrigger placement="right" overlay={tooltip}>
            <span className="glyphicon glyphicon-info-sign" />
          </OverlayTrigger>
        );

        metricsCountInfo = (
          <div>
            Metrics count:
            {' '}
            {maxMetricsCount}
            {' '}
            {tooltipButton}
          </div>
        );
      }
    }

    return <small>{metricsCountInfo}</small>;
  }
}

MetricsCountInfo.propTypes = {
  metricsCountByCluster: PropTypes.object.isRequired,
};

export default MetricsCountInfo;
