import Selectors from '../../utils/Selectors';

export function mustShowClusterServiceOnly(selectors) {
  const parsedSelectors = Selectors.parse(selectors);

  if (parsedSelectors.getNameSelector()) {
    return false;
  }

  const keys = parsedSelectors
    .getSelectors()
    .map((s) => s.getKey())
    .filter((k) => k !== 'project');

  return keys.length < 2 && (keys.length === 0 || keys.indexOf('cluster') >= 0 || keys.indexOf('service') >= 0);
}

export default mustShowClusterServiceOnly;
