import React from 'react';
import PropTypes from 'prop-types';

import { MUTES_STATUSES } from '../constants';

export default function MuteStatus({ mute }) {
  return (
    <span className={`label label-${MUTES_STATUSES[mute.status].style || 'default'}`}>
      {MUTES_STATUSES[mute.status].title}
    </span>
  );
}

MuteStatus.propTypes = {
  mute: PropTypes.object.isRequired,
};
