import React from 'react';
import { Link } from 'react-router-dom';

import './style.css';
import astro from './404.png';

const NotFoundPage = () => (
  <div className="container">
    <div className="not-found">
      <div className="row">
        <div className="col-md-6">
          <h3>Houston, we have a problem.</h3>
          <div className="not-found__description">
            Something went wrong. Please, refresh page or go to
            {' '}
            <Link to="/admin">main page</Link>
            .
          </div>
        </div>
        <div className="col-md-6">
          <img src={astro} className="not-found__astro" alt="notFound" />
        </div>
      </div>
    </div>
  </div>
);

export default NotFoundPage;
