/* eslint-disable operator-linebreak */
/* eslint-disable import/no-cycle */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';

import OldPageTitle from '../../../components/OldPageTitle';
import OldHeader from '../../../components/Header/OldHeader';
import TopLevelAlerts from '../../../components/TopLevelAlerts';

import ErrorBlock from '../components/ErrorBlock';
import OldDashboard from './OldDashboard';
import OldControlBar from '../components/ControlBar/OldControlBar';
import OldSelectors from '../components/OldSelectors/OldSelectors';
import TitleWithDescription from '../components/TitleWithDescription/TitleWithDescription';
import UrlUtils from '../../../utils/url/UrlUtils';
import TopLevelGraphAlerts from '../components/TopLevelGraphAlerts';
import GraphSettings from '../OldGraphPage/utils/GraphSettings';
import UserLinksBasic from '../../../utils/UserLinksBasic';
import BrowserUtils from '../../../utils/BrowserUtils';

import {
  loadDashboard, pinDashboard, unpinDashboard, clearDashboard,
} from '../../../store/reducers/old/oldDashboards';
import redirectToNewUi from '../utils/redirectToNewUi';
import { isPreOrProdIntEnv } from '../../../utils/env';
import { isTrue } from '../../../utils/boolean';
import NewUiAlert from '../../../components/NewUiAlert';
import {
  createConfiguredGraphOrDashboardUrl,
} from '../utils/graphToExpressionTransformations';

class OldDashboardPage extends PureComponent {
  componentDidMount() {
    if (!this.props.isLocal && this.props.graphOnly) {
      document.body.className = 'solomon-body-fullscreen';
    }
    if (this.props.canRedirectToNewUi) {
      redirectToNewUi(false);
    } else {
      this.fetchData();
    }
  }

  componentDidUpdate(prevProps) {
    if (!this.props.canRedirectToNewUi) {
      if (this.props.isLocal) {
        this.fetchIfNeededForLocal(prevProps);
      } else {
        this.fetchIfNeededForGlobal(prevProps);
      }
    }
    if (!this.props.isLocal && this.props.graphOnly) {
      document.body.className = 'solomon-body-fullscreen';
    } else {
      document.body.className = '';
    }
  }

  componentWillUnmount() {
    document.body.className = '';
    this.props.clearDashboard(this.props.id);
  }

  onPinDashboard = (pinProps) => {
    this.props.pinDashboard(this.props.id, pinProps);
  };

  onUnpinDashboard = (pinId) => {
    this.props.unpinDashboard(this.props.id, pinId);
  };

  fetchIfNeededForGlobal(prevProps) {
    if (this.props.location !== prevProps.location) {
      this.fetchData();
    }
  }

  fetchIfNeededForLocal(prevProps) {
    if (this.props.id !== prevProps.id) {
      this.fetchData();
    }
  }

  fetchData() {
    const baseParams = UrlUtils.parseUrlQueryArgs(this.props.url).toObject();
    this.props.loadDashboard(this.props.id, baseParams);
  }

  render() {
    let title = '';

    const {
      oldDashboardData, url, isLocal, graphOnly, canRedirectToNewUi,
    } = this.props;

    if (canRedirectToNewUi) {
      return 'Redirect to new UI...';
    }

    let mainElement;
    let menu = {};

    if (oldDashboardData.error !== null) {
      mainElement = (
        <ErrorBlock error={oldDashboardData.error} />
      );
    } else if (oldDashboardData.data === null) {
      if (oldDashboardData.loading) {
        mainElement = (<div className={`${graphOnly ? 'center' : ''}`}>Loading...</div>);
      } else {
        mainElement = null;
      }
    } else {
      title = oldDashboardData.data.windowTitle;
      menu = oldDashboardData.data.menu ? oldDashboardData.data.menu : {};

      const { dashboard } = oldDashboardData.data;

      let noncriticalAlert = null;
      let dashboardElement = null;

      if (oldDashboardData.data.noncriticalError) {
        noncriticalAlert = (
          <TopLevelGraphAlerts alerts={[oldDashboardData.data.noncriticalError]} />
        );
      }

      if (dashboard) {
        dashboardElement = (
          <OldDashboard
            url={url}
            appElement={this.props.appElement}
            isLocal={isLocal}
            dashboard={dashboard}
          />
        );
      }

      if (graphOnly) {
        mainElement = (
          <>
            {noncriticalAlert}
            {dashboardElement}
          </>
        );
      } else {
        const description = dashboard ? dashboard.description : '';

        const conf = {
          [UserLinksBasic.LEGEND_QUERY_ARG]:
            BrowserUtils.getLogicalQueryArgOrEmpty(UserLinksBasic.LEGEND_QUERY_ARG),
        };

        let newUiUrl = '';

        if (isPreOrProdIntEnv()) {
          const genId = dashboard.generatedId;
          if (genId) {
            newUiUrl = createConfiguredGraphOrDashboardUrl(genId);
          }
        }

        newUiUrl += '&utm_source=solomon_dashboard_view';

        mainElement = (
          <>
            <TopLevelAlerts admin={false} />
            <NewUiAlert type="dashboard" url={newUiUrl} />
            <OldSelectors selectors={oldDashboardData.data.selectors} />
            <TitleWithDescription
              title={oldDashboardData.data.graphTitle}
              description={description}
            />
            <OldControlBar
              genericResult={oldDashboardData.data}
              settings={GraphSettings.dashboardSettings}
              newUiUrl={newUiUrl}
              conf={conf}
              defaultConf={{}}
              pinPage={this.onPinDashboard}
              unpinPage={this.onUnpinDashboard}
            />
            {noncriticalAlert}
            {dashboardElement}
          </>
        );
      }
    }

    if (graphOnly) {
      return (
        <div className={`${isLocal ? '' : 'container-fluid '}container-solomon container-solomon-fullscreen`}>
          {mainElement}
        </div>
      );
    }

    return (
      <div>
        <OldPageTitle title={title} />
        <OldHeader menu={menu} location={this.props.location} />
        <div className="container-fluid container-solomon">
          {mainElement}
        </div>
      </div>
    );
  }
}

OldDashboardPage.propTypes = {
  id: PropTypes.string.isRequired,
  url: PropTypes.string.isRequired,
  appElement: PropTypes.instanceOf(Element).isRequired,
  isLocal: PropTypes.bool.isRequired,
  graphOnly: PropTypes.string.isRequired,
  location: PropTypes.object,
  canRedirectToNewUi: PropTypes.bool.isRequired,
  oldDashboardData: PropTypes.object.isRequired,
  loadDashboard: PropTypes.func.isRequired,
  pinDashboard: PropTypes.func.isRequired,
  unpinDashboard: PropTypes.func.isRequired,
  clearDashboard: PropTypes.func.isRequired,
};

OldDashboardPage.defaultProps = {
  location: null,
};

const defaultOldDashboardData = {
  loading: false,
  data: null,
  error: null,
};

const mapStateToProps = (state, ownProps) => {
  const oldDashboard = state.oldDashboards[ownProps.id];

  const forceOld = isTrue(BrowserUtils.getLogicalQueryArgOrEmpty('__old'));
  const forceNew = isTrue(
    BrowserUtils.getLogicalQueryArgOrEmpty('__force_new'),
  );

  const notForbiddenToRedirect =
    !ownProps.graphOnly &&
    state.userSettings.data.settings.redirectToNewUi === 'true' &&
    !forceOld;

  const canRedirectToNewUi =
    isPreOrProdIntEnv() && (notForbiddenToRedirect || forceNew);

  if (oldDashboard) {
    return {
      oldDashboardData: oldDashboard,
      canRedirectToNewUi,
    };
  }

  return { oldDashboardData: defaultOldDashboardData, canRedirectToNewUi };
};

const mapDispatchToProps = (dispatch) => bindActionCreators({
  loadDashboard,
  pinDashboard,
  unpinDashboard,
  clearDashboard,
}, dispatch);

export default connect(mapStateToProps, mapDispatchToProps)(OldDashboardPage);
