/* eslint-disable import/no-cycle,react/no-unused-state */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { match } from 'path-to-regexp';

import Markdown from '../../../components/Markdown/Markdown';
import OldMainPage from '../OldMainPage';
import UrlUtils from '../../../utils/url/UrlUtils';
import SubAlertsWidget from '../../alerts/SubAlertsPage/SubAlertsWidget';
import AlertSinglestatWidget from '../../alerts/AlertSinglestatPage/AlertSinglestatWidget';

const subAlertsMatch = match('/admin/projects/:projectId/alerts/:alertId/subAlerts/fullscreen');
const alertSinglestatMatch = match('/admin/projects/:projectId/alerts/:alertId/singlestat/fullscreen');
const subAlertSinglestatMatch = match('/admin/projects/:projectId/alerts/:alertId/subAlerts/:subAlertId/singlestat/fullscreen');

const LocalRegion = ({ width, height, children }) => (
  <div
    className="solomon-local-region"
    style={{ width, height }}
  >
    {children}
  </div>
);

LocalRegion.propTypes = {
  width: PropTypes.number.isRequired,
  height: PropTypes.number.isRequired,
  children: PropTypes.element.isRequired,
};

class OldDashboardPanel extends PureComponent {
  constructor(props) {
    super(props);
    this.elementRef = React.createRef();
  }

  componentDidMount() {
    // Hack to re-render dashboard panel after placeholder element mounting
    this.setState({ init: true });
  }

  renderPanel() {
    const { id, item, url } = this.props;

    let body;

    const $appElement = this.elementRef.current;
    const width = $appElement.clientWidth;
    const height = $appElement.clientHeight;

    if (item.type === 'MARKDOWN') {
      body = (
        <LocalRegion height={height} width={width}>
          <div className="container-fluid">
            <Markdown text={item.markdown} />
          </div>
        </LocalRegion>
      );
    } else if (url.startsWith('/?') || url.startsWith('?')) {
      body = (
        <LocalRegion width={width} height={height}>
          <OldMainPage
            id={id}
            url={`${url}&graphOnly=y`}
            appElement={$appElement}
            isLocal
          />
        </LocalRegion>
      );
    } else {
      let relativeUrl = url;

      if (relativeUrl.startsWith('http://solomon.yandex-team.ru')) {
        relativeUrl = relativeUrl.slice('http://solomon.yandex-team.ru'.length);
      } else if (relativeUrl.startsWith('https://solomon.yandex-team.ru')) {
        relativeUrl = relativeUrl.slice('https://solomon.yandex-team.ru'.length);
      }

      if (relativeUrl.startsWith('/admin/projects')) {
        const parsedUrl = UrlUtils.parseUrl(relativeUrl);
        const path = parsedUrl.getBeforeQuery();
        const search = parsedUrl.getQuery();

        let pathMatch = subAlertsMatch(path);
        if (pathMatch) {
          return (
            <LocalRegion width={width} height={height}>
              <SubAlertsWidget element={$appElement} match={pathMatch} search={search} />
            </LocalRegion>
          );
        }

        pathMatch = alertSinglestatMatch(path);
        if (pathMatch) {
          return (
            <LocalRegion width={width} height={height}>
              <AlertSinglestatWidget element={$appElement} match={pathMatch} search={search} />
            </LocalRegion>
          );
        }

        pathMatch = subAlertSinglestatMatch(path);
        if (pathMatch) {
          return (
            <LocalRegion width={width} height={height}>
              <AlertSinglestatWidget element={$appElement} match={pathMatch} search={search} />
            </LocalRegion>
          );
        }
      }

      body = (
        <iframe className="dashboard-item" frameBorder={0} src={url} title={item.title} />
      );
    }

    return body;
  }

  render() {
    let body = null;

    if (this.elementRef.current) {
      body = this.renderPanel();
    }

    return (
      <div className="dashboard-element-body" ref={this.elementRef}>
        {body}
      </div>
    );
  }
}

OldDashboardPanel.propTypes = {
  id: PropTypes.string.isRequired,
  item: PropTypes.object.isRequired,
  url: PropTypes.string.isRequired,
};

export default OldDashboardPanel;
