import { TableWithSpansBuilder, CellState } from './TableWithSpansBuilder';

class DashboardWithSpansUtils {
  static makeTableFromDashboardRows(rows) {
    const tableBuilder = new TableWithSpansBuilder();

    for (let rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
      const row = rows[rowIndex];
      for (let itemIndex = 0; itemIndex < row.items.length; ++itemIndex) {
        const item = row.items[itemIndex];
        tableBuilder.setSpannedCell(rowIndex, itemIndex, item.rowspan, item.colspan, item);
      }
    }
    return tableBuilder;
  }

  static extractJsRows(tableBuilder) {
    const newRows = [];

    const rowCount = tableBuilder.getRowCount();
    const columnCount = tableBuilder.getColumnCount();

    for (let rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
      const newItems = [];
      for (let itemIndex = 0; itemIndex < columnCount; ++itemIndex) {
        const fakeCell = tableBuilder.getCellOrEmpty(rowIndex, itemIndex);
        if (fakeCell.getState() !== CellState.INSIDE_SPANNED_CELL) {
          const newItem = DashboardWithSpansUtils.extractJsDashboardItem(
            fakeCell,
            columnCount,
            rowIndex,
            itemIndex,
          );
          newItems.push(newItem);
        }
      }
      newRows.push(newItems);
    }

    return newRows;
  }

  static extractJsDashboardItem(fakeCell, columnCount, rowIndex, itemIndex) {
    return {
      rowIndex,
      itemIndex,
      rowspan: fakeCell.getRowspan(),
      colspan: fakeCell.getColspan(),
      isEmpty: fakeCell.isEmptyCell(),
      cellWidth: fakeCell.isEmptyCell() ? 0 : (100 * fakeCell.getColspan()) / columnCount,
    };
  }
}

export default DashboardWithSpansUtils;
