/* eslint-disable jsx-a11y/interactive-supports-focus */
/* eslint-disable jsx-a11y/anchor-is-valid */
/* eslint-disable jsx-a11y/click-events-have-key-events */
import React, { Component } from 'react';
import PropTypes from 'prop-types';

import disconnectIcon from './disconnect-icon.png';
import ErrorModal from './ErrorModal';

import './style.css';

class DisconnectIcon extends Component {
  constructor(props) {
    super(props);
    this.state = { isModalOpen: false };
  }

  onModalShow = () => {
    this.setState({ isModalOpen: true });
  };

  onModalHide = () => {
    this.setState({ isModalOpen: false });
  };

  render() {
    return (
      <>
        {this.props.showIcon
          ? (
            <div className="graph-disconnect">
              <img alt="disconnectIcon" src={disconnectIcon} />
            </div>
          ) : null}
        <div style={{ textAlign: 'center' }}>
          <a role="button" style={{ cursor: 'pointer' }} onClick={this.onModalShow}>
            Failed to load graph
          </a>
        </div>
        <ErrorModal
          isOpen={this.state.isModalOpen}
          error={this.props.error}
          onCancel={this.onModalHide}
        />
      </>
    );
  }
}

DisconnectIcon.propTypes = {
  error: PropTypes.object.isRequired,
  showIcon: PropTypes.bool.isRequired,
};

export default DisconnectIcon;
