import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Modal from '../../../../components/Modal';
import ErrorBlock from '../../components/ErrorBlock';

class ErrorModal extends PureComponent {
  render() {
    return (
      <Modal
        title="Error"
        onCancel={this.props.onCancel}
        isOpen={this.props.isOpen}
        large
      >
        <ErrorBlock error={this.props.error} />
      </Modal>
    );
  }
}

ErrorModal.propTypes = {
  isOpen: PropTypes.bool.isRequired,
  error: PropTypes.object.isRequired,
  onCancel: PropTypes.func.isRequired,
};

export default ErrorModal;
