/* eslint-disable jsx-a11y/interactive-supports-focus */
/* eslint-disable jsx-a11y/anchor-is-valid */
/* eslint-disable jsx-a11y/click-events-have-key-events */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import ErrorModal from '../DisconnectIcon/ErrorModal';

import './style.css';

class GraphErrorPopup extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { isModalOpen: false };
  }

  onModalOpen = () => {
    this.setState({ isModalOpen: true });
  };

  onModalClose = () => {
    this.setState({ isModalOpen: false });
  };

  render() {
    let body;

    if (this.props.error && !window.navigator.onLine) {
      body = 'No connection';
    } else if (this.props.error
      && this.props.error instanceof Object
      && this.props.error.isNetworkError) {
      body = 'Network error';
    } else {
      body = (
        <>
          {this.props.message}
          , see
          {' '}
          <a className="show-error-link" role="button" onClick={this.onModalOpen}>details</a>
          <ErrorModal
            isOpen={this.state.isModalOpen}
            error={this.props.error}
            onCancel={this.onModalClose}
          />
        </>
      );
    }

    return (
      <div className="graph-error-popup-wrapper">
        <div className="graph-error-popup">
          {body}
        </div>
      </div>
    );
  }
}

GraphErrorPopup.propTypes = {
  message: PropTypes.string.isRequired,
  error: PropTypes.object.isRequired,
};

export default GraphErrorPopup;
