/* eslint-disable no-plusplus,react/no-string-refs */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import LegendSortedTable from './LegendSortedTable';
import LegendRow from './LegendRow';
import LegendButtonPanel from './LegendButtonPanel';
import BrowserUtils from '../../../../utils/BrowserUtils';
import UrlUtils from '../../../../utils/url/UrlUtils';
import UserLinksBasic from '../../../../utils/UserLinksBasic';

class ImprovedLegendWithStats extends PureComponent {
  onApply = () => {
    if (!this.refs.sortedTable) {
      return;
    }

    const checksArg = this.refs.sortedTable.computeChecksArg();

    const url = UrlUtils.updateParameter(
      BrowserUtils.getLogicalUrlAfterHost(),
      UserLinksBasic.CHECKS_QA,
      checksArg,
    );

    this.context.router.history.push(url);
  };

  render() {
    const {
      rows, columns, formatter, sensorLink,
    } = this.props;

    const shownCount = rows.filter((row) => row.show).length;

    const totalCount = rows.length;

    let status;
    if (shownCount !== totalCount) {
      status = `all (${totalCount}; ${shownCount} shown)`;
    } else if (totalCount >= 10) {
      status = `all (${totalCount})`;
    } else {
      status = 'all';
    }

    const legendRows = rows.map((row) => LegendRow.createNew(row, formatter, sensorLink));

    return (
      <div>
        <LegendSortedTable
          ref="sortedTable"
          rows={legendRows}
          labelColumnNames={columns}
          status={status}
        />
        <LegendButtonPanel
          rows={legendRows}
          labelColumnNames={columns}
          onApply={this.onApply}
        />
      </div>
    );
  }
}

ImprovedLegendWithStats.propTypes = {
  rows: PropTypes.array.isRequired,
  columns: PropTypes.array.isRequired,
  formatter: PropTypes.object.isRequired,
  sensorLink: PropTypes.object.isRequired,
};

ImprovedLegendWithStats.contextTypes = {
  router: PropTypes.object.isRequired,
};

export default ImprovedLegendWithStats;
