import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import SplitButton from 'react-bootstrap/es/SplitButton';
import MenuItem from 'react-bootstrap/es/MenuItem';
import ButtonGroup from 'react-bootstrap/es/ButtonGroup';
import Button from 'react-bootstrap/es/Button';
import ButtonToolbar from 'react-bootstrap/es/ButtonToolbar';
import createCsvData from './LegendCsvUtils';
import { copyContent } from '../../../../utils/clipboard';
import { downloadFile } from '../../../data/StockpileMetricPage/exportUtils';

class LegendButtonPanel extends PureComponent {
  componentDidMount() {
    this.setStickyPosition();
    if (this._el) {
      window.addEventListener('scroll', this.onScroll);
    }
  }

  componentWillUnmount() {
    window.removeEventListener('scroll', this.onScroll);
  }

  onScroll = () => {
    this.setStickyPosition();
  };

  onCopyCsv = () => {
    const csv = createCsvData(this.props.labelColumnNames, this.props.rows);
    copyContent(csv);
  };

  onDownloadCsv = () => {
    const csv = createCsvData(this.props.labelColumnNames, this.props.rows);
    downloadFile('data.csv', csv);
  };

  setStickyPosition() {
    const $table = document.querySelector('.solomon-legend.sorted-table');
    const $btnPanel = this._el;

    if (!$table || !$btnPanel) {
      return;
    }

    const isYetFixed = $btnPanel.classList.contains('legend-btn-panel-fixed');

    const tableBounds = $table.getBoundingClientRect();
    const panelBounds = $btnPanel.getBoundingClientRect();

    const panelHeight = panelBounds.height - (isYetFixed ? 10 : 0);
    const top = tableBounds.top + panelHeight;
    const bottom = (tableBounds.bottom + panelHeight) - 25;
    const clientHeight = window.innerHeight;
    if (top < clientHeight && clientHeight < bottom) {
      $btnPanel.classList.add('legend-btn-panel-fixed');
    } else {
      $btnPanel.classList.remove('legend-btn-panel-fixed');
    }
  }

  render() {
    return (
      <div className="legend-btn-panel" ref={(el) => { this._el = el; }}>
        <ButtonToolbar>
          <ButtonGroup>
            <Button onClick={this.props.onApply}>
              Apply
            </Button>
          </ButtonGroup>
          <SplitButton
            id="legend-csv-dropdown"
            title="Copy as CSV"
            onClick={this.onCopyCsv}
            dropup
          >
            <MenuItem onSelect={this.onDownloadCsv}>Download as CSV</MenuItem>
          </SplitButton>
        </ButtonToolbar>
      </div>
    );
  }
}

LegendButtonPanel.propTypes = {
  rows: PropTypes.array.isRequired,
  labelColumnNames: PropTypes.array.isRequired,
  onApply: PropTypes.func.isRequired,
};

export default LegendButtonPanel;
