/* eslint-disable no-continue,no-restricted-syntax */
const FORBIDDEN_CSV_SYMBOLS = /(\\s|\\")/;

function quoteCsvValue(value) {
  if (FORBIDDEN_CSV_SYMBOLS.test(value)) {
    return `"${value.replace(/\\"/g, '""')}"`;
  }
  return value;
}

// See https://tools.ietf.org/html/rfc4180
function createCsvData(columnNames, rows) {
  let csv = '';

  for (let i = 0; i < columnNames.length; ++i) {
    const name = columnNames[i];
    csv += `${name},`;
  }

  csv += 'Min,Max,Last,Avg,Sum\r\n';

  for (const row of rows) {
    if (!row.getChecked()) {
      continue;
    }

    for (let i = 0; i < columnNames.length; ++i) {
      const labelValue = row.getLabelColumnValueOrNull(i);
      csv += `${labelValue},`;
    }
    csv += `${quoteCsvValue(`${row.getMinForSort()}`)},`;
    csv += `${quoteCsvValue(`${row.getMaxForSort()}`)},`;
    csv += `${quoteCsvValue(`${row.getLastForSort()}`)},`;
    csv += `${quoteCsvValue(`${row.getAvgForSort()}`)},`;
    csv += `${quoteCsvValue(`${row.getSumForSort()}`)}\r\n`;
  }
  return csv;
}

export default createCsvData;
