class LegendRow {
  label;

  color;

  salmonId;

  link;

  labelColumnValues;

  checked;

  hasData;

  minForSort;

  maxForSort;

  avgForSort;

  sumForSort;

  lastForSort;

  minFormatted;

  maxFormatted;

  avgFormatted;

  sumFormatted;

  lastFormatted;

  static create(lineMetaData, nonTrivialLabelNames, sensorLink) {
    const row = new LegendRow();
    row.label = lineMetaData.label;
    row.color = lineMetaData.color;
    row.salmonId = lineMetaData.salmonId;
    row.link = sensorLink.addCurrentPageParams(lineMetaData.link);
    row.labelColumnValues = LegendRow.makeLabelColumnValues(lineMetaData, nonTrivialLabelNames);

    // Don't render legend row values (except checkbox and metric)
    row.hasData = false;

    row.checked = lineMetaData.show;

    row.minForSort = Number.POSITIVE_INFINITY;
    row.maxForSort = Number.POSITIVE_INFINITY;
    row.avgForSort = Number.POSITIVE_INFINITY;
    row.sumForSort = Number.POSITIVE_INFINITY;
    row.lastForSort = Number.POSITIVE_INFINITY;

    row.minFormatted = '';
    row.maxFormatted = '';
    row.avgFormatted = '';
    row.sumFormatted = '';
    row.lastFormatted = '';

    return row;
  }

  static createNew(dataRow, formatter, sensorLink) {
    const row = new LegendRow();
    row.label = dataRow.label;
    row.color = dataRow.color;
    row.salmonId = dataRow.salmonId;
    row.link = sensorLink.addCurrentPageParams(dataRow.link);
    row.labelColumnValues = dataRow.legendNames;
    row.hasData = dataRow.show;
    row.checked = dataRow.show;

    if (dataRow.show) {
      const salmonStats = dataRow.salmonStats || {};

      row.minForSort = salmonStats.min;
      row.maxForSort = salmonStats.max;
      row.avgForSort = salmonStats.avg;
      row.sumForSort = salmonStats.sum;
      row.lastForSort = salmonStats.last;

      row.minFormatted = formatter.format(salmonStats.min);
      row.maxFormatted = formatter.format(salmonStats.max);
      row.avgFormatted = formatter.format(salmonStats.avg);
      row.sumFormatted = LegendRow.formatSum(formatter, salmonStats.sum);
      row.lastFormatted = formatter.format(salmonStats.last);
    } else {
      row.minForSort = Number.POSITIVE_INFINITY;
      row.maxForSort = Number.POSITIVE_INFINITY;
      row.avgForSort = Number.POSITIVE_INFINITY;
      row.sumForSort = Number.POSITIVE_INFINITY;
      row.lastForSort = Number.POSITIVE_INFINITY;

      row.minFormatted = '';
      row.maxFormatted = '';
      row.avgFormatted = '';
      row.sumFormatted = '';
      row.lastFormatted = '';
    }

    return row;
  }

  static makeLabelColumnValues(lineMetaData, nonTrivialLabelNames) {
    let labelColumnValues;
    if (nonTrivialLabelNames.length > 1) {
      labelColumnValues = [];
      for (let i = 0; i < nonTrivialLabelNames.length; i++) {
        const nonTrivialLabelName = nonTrivialLabelNames[i];
        let nonTrivialLabelValue = lineMetaData.sensorLabels[nonTrivialLabelName] || '';
        if (!nonTrivialLabelValue) {
          nonTrivialLabelValue = '-';
        }
        labelColumnValues[i] = nonTrivialLabelValue;
      }
    } else {
      labelColumnValues = [lineMetaData.label];
    }
    return labelColumnValues;
  }

  static extractFromMetaAndGraphData(
    lineMetaData,
    lineData,
    formatter,
    nonTrivialLabelNames,
    sensorLink,
  ) {
    const row = LegendRow.create(lineMetaData, nonTrivialLabelNames, sensorLink);
    row.update(lineData, formatter);
    return row;
  }

  update(lineData, formatter) {
    const salmonStats = lineData.salmonStats || {};

    this.minForSort = salmonStats.min;
    this.maxForSort = salmonStats.max;
    this.avgForSort = salmonStats.avg;
    this.sumForSort = salmonStats.sum;
    this.lastForSort = salmonStats.last;

    this.minFormatted = formatter.format(salmonStats.min);
    this.maxFormatted = formatter.format(salmonStats.max);
    this.avgFormatted = formatter.format(salmonStats.avg);
    this.sumFormatted = LegendRow.formatSum(formatter, salmonStats.sum);
    this.lastFormatted = formatter.format(salmonStats.last);

    // Render legend row values
    this.hasData = true;
  }

  static formatSum(formatter, value) {
    return value == null ? 'Not derived' : formatter.format(value);
  }

  getLabelColumnValueOrNull(columnIndex) {
    if (columnIndex >= 0 && columnIndex < this.labelColumnValues.length) {
      return this.labelColumnValues[columnIndex];
    }

    return null;
  }

  // Needed get methods
  getLabel() {
    return this.label;
  }

  getSalmonId() {
    return this.salmonId;
  }

  getChecked() {
    return this.checked;
  }

  getMinForSort() {
    return this.minForSort;
  }

  getMaxForSort() {
    return this.maxForSort;
  }

  getAvgForSort() {
    return this.avgForSort;
  }

  getLastForSort() {
    return this.lastForSort;
  }

  getSumForSort() {
    return this.sumForSort;
  }
}

export default LegendRow;
