import UrlUtils from '../../../../utils/url/UrlUtils';
import UserLinksBasic from '../../../../utils/UserLinksBasic';

class LegendStyle {
  static OFF = 'off';

  static SIMPLE = 'simple';

  static FULL = 'full';

  static fromUrl(url, graphOnly) {
    const parsedUrl = UrlUtils.parseUrl(url);
    const legendOptBool = parsedUrl.getLogicalQueryArgOptBoolean(UserLinksBasic.LEGEND_QUERY_ARG);

    if (legendOptBool === false) {
      return LegendStyle.OFF;
    }

    const legendFromArg = legendOptBool === true;

    const needLegend = !graphOnly || legendFromArg;
    if (!needLegend) {
      return LegendStyle.OFF;
    }

    // legendFromArg is always true at this point if graphOnly is true,
    // but adding it to condition makes code clearer
    if (graphOnly && legendFromArg) {
      return LegendStyle.SIMPLE;
    }

    return LegendStyle.FULL;
  }
}

export default LegendStyle;
