import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import LegendStyle from './LegendStyle';
import SimpleLegend from './SimpleLegend';

import ImprovedLegendWithStats from './ImprovedLegendWithStats';

import './style.css';

class OldImprovedLegend extends PureComponent {
  render() {
    switch (this.props.style) {
      case LegendStyle.OFF:
        return null;
      case LegendStyle.SIMPLE:
        return <SimpleLegend rows={this.props.rows} />;
      case LegendStyle.FULL:
        return (
          <ImprovedLegendWithStats
            rows={this.props.rows}
            columns={this.props.columns}
            formatter={this.props.formatter}
            sensorLink={this.props.sensorLink}
          />
        );
      default:
        throw new Error(`unknown legend style: ${this.props.style}`);
    }
  }
}

OldImprovedLegend.propTypes = {
  style: PropTypes.string.isRequired,
  rows: PropTypes.array.isRequired,
  columns: PropTypes.array.isRequired,
  formatter: PropTypes.object.isRequired,
  sensorLink: PropTypes.object.isRequired,
};

export default OldImprovedLegend;
