import Parser from '../../../../utils/Parser';
import { consumeEscapedString } from '../../../../utils/Quoter';

class SensorsChecksSet {
  constructor(positive, ids) {
    this.positive = positive;
    this.ids = ids;
  }

  makeQueryArgValue() {
    const startSymbol = this.positive ? '+' : '-';
    const tail = SensorsChecksSet._makeTailFromSensorIds(this.ids);
    return startSymbol + tail;
  }

  include(id) {
    return this.positive === (this.ids.indexOf(id) >= 0);
  }

  static parse(value) {
    if (!value) {
      return new SensorsChecksSet(false, []);
    }

    const startSymbol = value[0];
    const tail = value.substr(1);

    let positive;
    switch (startSymbol) {
      case '+':
        positive = true;
        break;
      case '-':
        positive = false;
        break;
      default:
        return new SensorsChecksSet(false, []);
    }

    const sensorIds = SensorsChecksSet._parseSensorIdsFromTail(tail);

    return new SensorsChecksSet(positive, sensorIds);
  }

  static _parseSensorIdsFromTail(tail) {
    const sensorIds = [];

    if (tail) {
      const parser = Parser.create(tail);

      while (parser.hasNext()) {
        const sensorId = consumeEscapedString(parser, ';');
        if (parser.hasNext()) {
          parser.consumeExpectedChar(';');
        }
        sensorIds.push(sensorId);
      }
    }
    return sensorIds;
  }

  static _makeTailFromSensorIds(sensorIds) {
    return sensorIds.map((id) => SensorsChecksSet._escapeSensorId(id)).join(';');
  }

  static _escapeSensorId(id) {
    return id.replace(/\\/g, '\\\\').replace(/;/g, '\\;');
  }
}

export default SensorsChecksSet;
