/* eslint-disable jsx-a11y/label-has-for */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class SimpleLegend extends PureComponent {
  static renderRow(row) {
    if (!row.show) {
      return null;
    }

    return (
      <li key={row.salmonId}>
        <div style={{ border: '1px solid #ccc', padding: '1px', display: 'inline-block' }}>
          <div style={{
            width: '4px',
            height: '0',
            border: `5px solid ${row.color}`,
            overflow: 'hidden',
          }}
          />
        </div>
        <label>
          {row.label}
        </label>
      </li>
    );
  }

  render() {
    const { rows } = this.props;

    return (
      <ul className="solomon-legend legend-simple">
        {rows.map((row) => SimpleLegend.renderRow(row)).filter((row) => row !== null)}
      </ul>
    );
  }
}

SimpleLegend.propTypes = {
  rows: PropTypes.array.isRequired,
};

export default SimpleLegend;
