/* eslint-disable jsx-a11y/interactive-supports-focus */
/* eslint-disable jsx-a11y/click-events-have-key-events */
/* eslint-disable jsx-a11y/control-has-associated-label */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import HealthAlerting from '../HealthAlerting';
import ShardHealthModal from './ShardHealthModal';

import './style.css';

function makeAlertTypeFromStatus(status) {
  switch (status) {
    case HealthAlerting.WARNING:
      return 'alert-warning';
    case HealthAlerting.DANGER:
      return 'alert-danger';
    default:
      throw new Error(`unknown status: ${status}`);
  }
}

class ShardHealthAlert extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { isModalOpen: false };
  }

  onModalOpen = () => {
    this.setState({ isModalOpen: true });
  };

  onModalClose = () => {
    this.setState({ isModalOpen: false });
  };

  render() {
    const healthValue = this.props.health.value;
    const status = HealthAlerting.computeStatus(healthValue);
    if (status !== HealthAlerting.OK) {
      const alertType = makeAlertTypeFromStatus(status);

      return (
        <div
          className={`alert-warning-popup ${alertType}`}
          role="alert"
          style={{ top: this.props.top, left: this.props.left }}
        >
          <i className="glyphicon glyphicon-exclamation-sign" role="button" onClick={this.onModalOpen} />
          <ShardHealthModal
            health={this.props.health}
            isOpen={this.state.isModalOpen}
            onCancel={this.onModalClose}
          />
        </div>
      );
    }

    return null;
  }
}

ShardHealthAlert.propTypes = {
  health: PropTypes.object.isRequired,
  top: PropTypes.number.isRequired,
  left: PropTypes.number.isRequired,
};

export default ShardHealthAlert;
