import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import UrlUtils from '../../../../utils/url/UrlUtils';
import Modal from '../../../../components/Modal';
import BrowserUtils from '../../../../utils/BrowserUtils';

class ShardHealthModal extends PureComponent {
  render() {
    const { health, isOpen } = this.props;

    const adminLink = `/admin/projects/${health.projectId}/shards/${health.shardId}/status?status=NOT_OK`;

    const mailSubject = 'Please help to fix graphs!';
    const mailBody = `Please help to fix graphs here: ${BrowserUtils.locationHref()}!`;

    const mailLink = UrlUtils.addTwoParameters('mailto:solomon@yandex-team.ru', 'subject', mailSubject, 'body', mailBody);

    return (
      <Modal title="Warning!" onCancel={this.props.onCancel} isOpen={isOpen}>
        <div className="modal-body">
          There are some problems with data collection for the shard that this graph belongs
          to.
          <br />
          Potentially, this can affect this graph, so that the data being displayed on it
          may not be complete or even may have discrepancies.
          <br />
          You can do the following:
          <ol>
            <li>
              <b>(recommended)</b>
              {' '}
              fix the problems on
              {' '}
              <a href={adminLink}>shard status page</a>
              &nbsp;(additional permissions may be required)
            </li>
            <li>
              send an email to
              {' '}
              <a href={mailLink}>solomon@</a>
              {' '}
              mailing list or
              a message to
              {' '}
              <a href="https://nda.ya.ru/t/4XRL2d_13YLtZs">
                telegram chat
              </a>
              {' '}
              with the link to this dashboard or graph
            </li>
            <li>
              <b>(not recommended)</b>
              {' '}
              you can completely disable these notifications
              or change the alerting thresholds on the
              {' '}
              <a href="/admin/preferences">
                preferences page
              </a>
              {' '}
              <b>(changes will be applied only for current user)</b>
              .
            </li>
          </ol>
        </div>
      </Modal>
    );
  }
}

ShardHealthModal.propTypes = {
  health: PropTypes.object.isRequired,
  isOpen: PropTypes.bool.isRequired,
  onCancel: PropTypes.func.isRequired,
};

export default ShardHealthModal;
