import UserLinksBasic from '../../../../utils/UserLinksBasic';
import { parseDuration } from '../../../../utils/duration';
import * as TimeUnit from '../../../../solomon-graph/xaxis/TimeUnit';
import { isTrueOrPositive } from '../../../../utils/boolean';

class AutorefreshUtils {
  static DEFAULT_POINT_COUNT = 500;

  static defaultAutorefreshInterval() {
    return Math.trunc((60000 + ((Math.random() * 20000))) - 10000);
  }

  static isAutorefresh(urlParsed) {
    const autorefresh = urlParsed.getLogicalQueryArgOrEmpty(UserLinksBasic.AUTOREFRESH_QA);
    if (autorefresh) {
      return isTrueOrPositive(autorefresh);
    }
    const e = urlParsed.getLogicalQueryArgOrEmpty(UserLinksBasic.E_QA);
    if (!e) {
      return true;
    }
    const parsedE = parseDuration(e);
    return parsedE !== null;
  }

  static autorefreshIntervalMillis(urlParsed) {
    // eslint-disable-next-line max-len
    let interval = urlParsed.getLogicalQueryArgNonNegativeIntegerOr(UserLinksBasic.AUTOREFRESH_QA, 0);

    if (interval === 0) {
      const b = urlParsed.getLogicalQueryArgOrEmpty(UserLinksBasic.B_QA);

      const durationMillis = parseDuration(b);

      if (durationMillis !== null) {
        if (durationMillis < TimeUnit.DAY_MILLIS) {
          interval = AutorefreshUtils.defaultAutorefreshInterval();
        } else {
          interval = durationMillis / AutorefreshUtils.DEFAULT_POINT_COUNT;
        }
      } else {
        interval = AutorefreshUtils.defaultAutorefreshInterval();
      }
    }

    if (interval < 1000) {
      interval = 1000;
    }
    return interval;
  }
}

export default AutorefreshUtils;
