/* eslint-disable no-param-reassign */
import UserLinksBasic from '../../../../utils/UserLinksBasic';
import UrlUtils from '../../../../utils/url/UrlUtils';

class SensorLink {
  constructor(b, e) {
    this.b = b;
    this.e = e;
  }

  static fromUrl(url) {
    const urlParsed = UrlUtils.parseUrl(url);
    const b = urlParsed.getLogicalQueryArgOrEmpty(UserLinksBasic.B_QA);
    const e = urlParsed.getLogicalQueryArgOrEmpty(UserLinksBasic.E_QA);
    return new SensorLink(b, e);
  }

  addCurrentPageParams(link) {
    if (!link) {
      return '';
    }

    if (UserLinksBasic.isGeneric(link)) {
      if (this.b) {
        link = UrlUtils.updateParameter(link, UserLinksBasic.B_QA, this.b);
      } else {
        link = UrlUtils.removeQueryArgs(link, UserLinksBasic.B_QA);
      }
      if (this.e) {
        link = UrlUtils.updateParameter(link, UserLinksBasic.E_QA, this.e);
      } else {
        link = UrlUtils.removeQueryArgs(link, UserLinksBasic.E_QA);
      }
      return link;
    }

    return link;
  }
}

export default SensorLink;
