/* eslint-disable import/no-cycle */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import OldProjectsPage from './OldProjectsPage/OldProjectsPage';
import OldGraphPage from './OldGraphPage/OldGraphPage';
import OldDashboardPage from './OldDashboardPage/OldDashboardPage';
import OldSensorsPage from './OldSensorsPage/OldSensorsPage';
import UrlUtils from '../../utils/url/UrlUtils';
import UserLinksBasic from '../../utils/UserLinksBasic';
import BrowserUtils from '../../utils/BrowserUtils';
import OldSubProjectPageWrapper from '../projects/OldSubProjectPageWrapper';

class OldMainPage extends Component {
  shouldComponentUpdate() {
    return true;
  }

  render() {
    const id = this.props.id || 'root';
    const appElement = this.props.appElement || document.querySelector('#root') || document.body;
    const { isLocal } = this.props;

    let url;

    if (isLocal) {
      url = this.props.url;
    } else {
      url = this.props.location.pathname + this.props.location.search + this.props.location.hash;
    }

    // See https://st.yandex-team.ru/SOLOMON-171
    const urlWithoutHash = url.replace('/#/', '/');
    if (urlWithoutHash !== url) {
      url = urlWithoutHash;
      BrowserUtils.setLocationHref(url);
    }

    const urlParsed = UrlUtils.parseUrl(url);

    const graphOnly = isLocal
      || urlParsed.getLogicalQueryArgBoolean(UserLinksBasic.GRAPH_ONLY_QA)
      || BrowserUtils.inIframe();

    const project = urlParsed.getLogicalQueryArgOrEmpty('project');

    if (project) {
      const graph = urlParsed.getLogicalQueryArgOrEmpty('graph');
      const dashboard = urlParsed.getLogicalQueryArgOrEmpty('dashboard');

      if (graph) {
        return (
          <OldSubProjectPageWrapper projectId={project} graphOnly={graphOnly}>
            <OldGraphPage
              id={id}
              url={url}
              appElement={appElement}
              isLocal={isLocal}
              graphOnly={graphOnly}
              location={this.props.location}
            />
          </OldSubProjectPageWrapper>
        );
      }

      if (dashboard) {
        return (
          <OldSubProjectPageWrapper projectId={project} graphOnly={graphOnly}>
            <OldDashboardPage
              id={id}
              url={url}
              appElement={appElement}
              graphOnly={graphOnly}
              isLocal={isLocal}
              location={this.props.location}
            />
          </OldSubProjectPageWrapper>
        );
      }

      if (graphOnly) {
        return null;
      }

      return (
        <OldSubProjectPageWrapper projectId={project} graphOnly={graphOnly}>
          <OldSensorsPage {...this.props} />
        </OldSubProjectPageWrapper>
      );
    }

    if (graphOnly) {
      return null;
    }

    return <OldProjectsPage {...this.props} />;
  }
}

OldMainPage.propTypes = {
  id: PropTypes.string,
  url: PropTypes.string,
  appElement: PropTypes.instanceOf(Element),
  isLocal: PropTypes.bool,
  location: PropTypes.object,
};

OldMainPage.defaultProps = {
  // Local component props
  id: null,
  url: null,
  appElement: null,
  isLocal: false,
  // Global component props
  location: null,
};

export default OldMainPage;
