import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';
import UserLinksBasic from '../../../utils/UserLinksBasic';

const MAX_SENSORS_TO_SHOW_TABLE_COUNT = 10000;
const MAX_SENSORS_TO_SHOW_GRAPH_COUNT = 500;
const MIN_SENSORS_TO_SHOW_GRAPH_WITH_TOP_COUNT = 100;

class AutoGraphBlock extends PureComponent {
  render() {
    const { search, sensorsCount, isSingleNonTrivialLabel } = this.props;

    if (sensorsCount === 0) {
      return null;
    }

    if (sensorsCount > MAX_SENSORS_TO_SHOW_TABLE_COUNT) {
      return null;
    }

    if (sensorsCount > MAX_SENSORS_TO_SHOW_GRAPH_COUNT && isSingleNonTrivialLabel) {
      return null;
    }

    const autoGraphLink = UserLinksBasic.fixOldAdminUrl(`${search}&graph=auto`);
    const autoTableLink = `${autoGraphLink}&graphMode=none&secondaryGraphMode=none`;
    const autoGraphWithTopLink = `${autoGraphLink}&filter=top&filterBy=avg&filterLimit=30`;

    const canShowAutoGraph = sensorsCount <= MAX_SENSORS_TO_SHOW_GRAPH_COUNT;
    const canShowAutoGraphWithTop = sensorsCount >= MIN_SENSORS_TO_SHOW_GRAPH_WITH_TOP_COUNT;

    return (
      <div>
        <h4>Auto graph</h4>
        <ul>
          {canShowAutoGraph && (
            <li><Link to={autoGraphLink}>Graph</Link></li>
          )}
          {canShowAutoGraphWithTop && (
            <li><Link to={autoGraphWithTopLink}>Graph with TOP-30</Link></li>
          )}
          <li><Link to={autoTableLink}>Table (not recommended)</Link></li>
        </ul>
      </div>
    );
  }
}

AutoGraphBlock.propTypes = {
  search: PropTypes.string.isRequired,
  isSingleNonTrivialLabel: PropTypes.bool.isRequired,
  sensorsCount: PropTypes.number.isRequired,
};

export default AutoGraphBlock;
