import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';
import UserLinksBasic from '../../../utils/UserLinksBasic';

class MatchingItemsBlock extends PureComponent {
  render() {
    const {
      projectId, title, type, items,
    } = this.props;

    if (items.length === 0) {
      return null;
    }

    return (
      <div>
        <h4>{title}</h4>
        <ul>
          {items.map((item) => {
            const searchParams = new URLSearchParams();

            searchParams.set('project', projectId);
            item.parameters.forEach((p) => searchParams.set(p.name, p.value));
            searchParams.set(type, item.id);

            const url = UserLinksBasic.fixOldAdminUrl(`/?${searchParams.toString()}`);

            return (
              <li key={item.id}>
                <Link to={url}>{item.name}</Link>
              </li>
            );
          })}
        </ul>
      </div>
    );
  }
}

MatchingItemsBlock.propTypes = {
  projectId: PropTypes.string.isRequired,
  title: PropTypes.string.isRequired,
  type: PropTypes.string.isRequired,
  items: PropTypes.array.isRequired,
};

export default MatchingItemsBlock;
