import React, { useCallback } from 'react';
import PropTypes from 'prop-types';

import { ReactComponent as InternalMonitoringIcon } from './icons/monitoring.svg';

export const MonitoringIcon = (props) => (
  <InternalMonitoringIcon
    style={{ marginBottom: 2, verticalAlign: 'middle' }}
    {...props}
  />
);

const MonitoringButton = ({ href, disabled }) => {
  const goToMonitoring = useCallback(
    () => {
      window.open(href, '_blank');
    },
    [href],
  );

  return (
    <button type="button" className="btn btn-primary" disabled={disabled} onClick={goToMonitoring}>
      <MonitoringIcon />
      <span style={{ marginLeft: 8, fontWeight: 'bold' }}>
        Open in Monitoring
      </span>
    </button>
  );
};

MonitoringButton.propTypes = {
  href: PropTypes.string.isRequired,
  disabled: PropTypes.bool,
};

MonitoringButton.defaultProps = {
  disabled: false,
};

export default MonitoringButton;
