/* eslint-disable no-restricted-syntax,no-nested-ternary */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Dropdown from 'react-bootstrap/es/Dropdown';
import MenuItem from 'react-bootstrap/es/MenuItem';

import OldGraphConfigureModal from '../../OldGraphPage/OldGraphConfigureModal';
import OldTimeBar from './TimeBar/OldTimeBar';
import OldShareModal from './OldShareModal/OldShareModal';
import PinButton from './PinButton/PinButton';
import UserLinksBasic from '../../../../utils/UserLinksBasic';
import BrowserUtils from '../../../../utils/BrowserUtils';
import ConfiguredGraphCreationModal from './ConfiguredGraphCreationModal';
import UrlUtils from '../../../../utils/url/UrlUtils';

import AlertCreationModal from './AlertCreationModal';
import QuickCopyButton from '../../../../components/QuickCopyButton/QuickCopyButton';

import { store } from '../../../../store';
import { setGraph } from '../../../../store/reducers/graphs/graph';
import { setAlert } from '../../../../store/reducers/alerts/alert';
import { createAdminAutoGraphUrl } from '../../utils/graphToExpressionTransformations';

import { isCloud } from '../../../../utils/env';

import MonitoringButton from './MonitoringButton';

function createStaticUrl(timeRange) {
  const baseHashUrl = UrlUtils.removeQueryArgs(BrowserUtils.locationHref(),
    UserLinksBasic.B_QA, UserLinksBasic.E_QA,
    UserLinksBasic.GRAPH_ONLY_QA,
    UserLinksBasic.AUTOREFRESH_QA);

  return UrlUtils.addTwoParameters(
    baseHashUrl,
    UserLinksBasic.B_QA, timeRange.begin.instant,
    UserLinksBasic.E_QA, timeRange.end.instant,
  );
}

class OldControlBar extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      isConfigModalOpen: false,
      isShareModalOpen: false,
      isAlertModalShown: false,
      isGraphModalShown: false,
    };
  }

  onConfigModalHide = () => {
    this.setState({ isConfigModalOpen: false });
  };

  onConfigModalShow = () => {
    this.setState({ isConfigModalOpen: true });
  };

  onShareModalHide = () => {
    this.setState({ isShareModalOpen: false });
  };

  onShareModalShow = () => {
    this.setState({ isShareModalOpen: true });
  };

  onConfigModalApply = (newUrl) => {
    this.setState({ isConfigModalOpen: false }, () => {
      this.context.router.history.push(newUrl);
    });
  };

  onGraphModalShow = () => {
    this.setState({ isGraphModalShown: true });
  };

  onGraphModalHide = () => {
    this.setState({ isGraphModalShown: false });
  };

  onGraphModalApply = (newUrl, body) => {
    store.dispatch(setGraph(body));
    this.setState({ isGraphModalShown: false }, () => {
      this.context.router.history.push(newUrl);
    });
  };

  onAlertModalShow = () => {
    this.setState({ isAlertModalShown: true });
  };

  onAlertModalHide = () => {
    this.setState({ isAlertModalShown: false });
  };

  onAlertModalApply = (newUrl, body) => {
    store.dispatch(setAlert(body));
    this.setState({ isAlertModalShown: false }, () => {
      this.context.router.history.push(newUrl);
    });
  };

  render() {
    const {
      currentPageIdInHistory, graphTitle,
      fullItem, navButtons, timeRange,
    } = this.props.genericResult;

    const {
      settings, conf, defaultConf, newUiUrl,
    } = this.props;

    const projectId = BrowserUtils.getLogicalQueryArgOrEmpty(UserLinksBasic.PROJECT);

    const url = BrowserUtils.getLogicalUrlAfterHost();

    const graphOnlyUrl = UrlUtils.addParameter(url, 'graphOnly', 'y');

    const staticUrl = createStaticUrl(timeRange);

    const graphParam = BrowserUtils.getLogicalQueryArgOrEmpty(UserLinksBasic.GRAPH_PARAM);

    const isAutoGraphParam = graphParam === UserLinksBasic.GRAPH_VALUE_AUTO;

    const autoGraphUrl = isAutoGraphParam ? createAdminAutoGraphUrl() : '';

    return (
      <div className="clearfix" style={{ marginBottom: '7px' }}>
        <div className="pull-left btn-toolbar">
          <button type="button" className="btn btn-default" onClick={this.onShareModalShow}>
            Share...
          </button>
          <button type="button" className="btn btn-default" onClick={this.onConfigModalShow}>
            Configure...
          </button>
          <PinButton
            historyId={currentPageIdInHistory}
            graphTitle={graphTitle}
            pinPage={this.props.pinPage}
            unpinPage={this.props.unpinPage}
          />
          <Dropdown id="share-btn">
            <Dropdown.Toggle style={{ boxShadow: 'none', background: 'transparent', border: 'transparent' }} noCaret>
              <i className="glyphicon glyphicon-option-vertical" />
            </Dropdown.Toggle>
            <Dropdown.Menu>
              {isAutoGraphParam && (
                <MenuItem key="create_configured_graph" onClick={this.onGraphModalShow}>
                  Create configured graph
                </MenuItem>
              )}
              {isAutoGraphParam && (
                <MenuItem key="create_alert" onClick={this.onAlertModalShow}>
                  Create alert
                </MenuItem>
              )}
              {!!autoGraphUrl && (
                <MenuItem key="go_to_admin_autograph" href={autoGraphUrl}>
                  Go to admin autograph
                </MenuItem>
              )}
              <MenuItem key="fullscreen-item" href={graphOnlyUrl}>
                Fullscreen
              </MenuItem>
            </Dropdown.Menu>
          </Dropdown>
          <QuickCopyButton url={staticUrl} />
          {!isCloud() && (
            <MonitoringButton href={newUiUrl} />
          )}
          {this.state.isShareModalOpen && (
            <OldShareModal
              fullItem={fullItem}
              timeRange={timeRange}
              onCancel={this.onShareModalHide}
            />
          )}
          <OldGraphConfigureModal
            projectId={projectId}
            conf={conf}
            defaultConf={defaultConf}
            settings={settings}
            isOpen={this.state.isConfigModalOpen}
            onApply={this.onConfigModalApply}
            onCancel={this.onConfigModalHide}
          />
          <ConfiguredGraphCreationModal
            defaultProjectId={projectId}
            isOpen={this.state.isGraphModalShown}
            onApply={this.onGraphModalApply}
            onCancel={this.onGraphModalHide}
          />
          <AlertCreationModal
            defaultProjectId={projectId}
            isOpen={this.state.isAlertModalShown}
            onApply={this.onAlertModalApply}
            onCancel={this.onAlertModalHide}
          />
        </div>
        <div className="pull-right">
          <OldTimeBar
            navButtons={navButtons}
            timeRange={timeRange}
          />
        </div>
      </div>
    );
  }
}

OldControlBar.propTypes = {
  genericResult: PropTypes.object.isRequired,
  newUiUrl: PropTypes.string.isRequired,
  settings: PropTypes.array.isRequired,
  conf: PropTypes.object.isRequired,
  defaultConf: PropTypes.object.isRequired,
  pinPage: PropTypes.func.isRequired,
  unpinPage: PropTypes.func.isRequired,
};

OldControlBar.contextTypes = {
  router: PropTypes.shape({
    history: PropTypes.object.isRequired,
  }).isRequired,
};

export default OldControlBar;
