/* eslint-disable jsx-a11y/interactive-supports-focus,jsx-a11y/anchor-is-valid */
/* eslint-disable jsx-a11y/click-events-have-key-events */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { copyContent } from '../../../../../utils/clipboard';

class CopyLinkButton extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { showCopied: false };
  }

  onClick = (event) => {
    event.preventDefault();

    copyContent(this.props.value);

    this.setState({ showCopied: true }, () => {
      window.setTimeout(() => { this.setState({ showCopied: false }); }, 1000);
    });
  };

  render() {
    if (this.state.showCopied) {
      return 'Copied!';
    }

    return (
      <a role="button" style={{ cursor: 'pointer' }} onClick={this.onClick}>Copy</a>
    );
  }
}

CopyLinkButton.propTypes = {
  value: PropTypes.string.isRequired,
};

export default CopyLinkButton;
