/* eslint-disable jsx-a11y/label-has-associated-control */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import CopyLinkButton from './CopyLinkButton';
import createShortUrl from '../../../../../utils/createShortUrl';

class ShortLinkFormGroup extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { showShortUrl: false, shortUrl: '' };
  }

  componentDidUpdate(prevProps, prevState) {
    if (this._input && !prevState.showShortUrl) {
      this._input.select();
    }
    if (this.props.value !== prevProps.value) {
      this.setState({ showShortUrl: false, shortUrl: '' });
    }
  }

  onClick = () => {
    createShortUrl(this.props.value).then((shortUrl) => {
      this.setState({ showShortUrl: true, shortUrl });
    });
  };

  render() {
    if (!this.state.showShortUrl) {
      return (
        <div className="form-group">
          <label className="col-sm-3 control-label" />
          <div className="col-sm-7">
            <button type="button" className="btn btn-default" onClick={this.onClick}>
              Generate short link
            </button>
          </div>
          <div className="col-sm-2 control-label" />
        </div>
      );
    }

    return (
      <div className="form-group short-link">
        <label className="col-sm-3 control-label" />
        <div className="col-sm-7">
          <input
            type="text"
            className="form-control"
            readOnly
            value={this.state.shortUrl}
            ref={(input) => { this._input = input; }}
          />
        </div>
        <div className="col-sm-2 control-label" style={{ textAlign: 'left' }}>
          <CopyLinkButton value={this.state.shortUrl} />
        </div>
      </div>
    );
  }
}

ShortLinkFormGroup.propTypes = {
  value: PropTypes.string.isRequired,
};

export default ShortLinkFormGroup;
