import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

import PinModal from './PinModal';
import BrowserUtils from '../../../../../utils/BrowserUtils';
import UserLinksBasic from '../../../../../utils/UserLinksBasic';

class PinButton extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { isModalOpen: false };
  }

  onPinToggle = () => {
    if (this.props.historyId) {
      this.props.unpinPage(this.props.historyId);
    } else {
      this.setState({ isModalOpen: true });
    }
  };

  onModalApply = (title) => {
    this.setState({ isModalOpen: false }, () => {
      const url = UserLinksBasic.unfixOldAdminUrl(BrowserUtils.getLogicalUrlAfterHost());
      this.props.pinPage({ url, title });
    });
  };

  onModalCancel = () => {
    this.setState({ isModalOpen: false });
  };

  render() {
    const { historyId, graphTitle } = this.props;

    const styleClass = historyId ? 'btn-primary' : 'btn-default';

    return (
      <div className="btn-group">
        <button type="button" className={`btn ${styleClass}`} onClick={this.onPinToggle}>
          Pin
        </button>
        {this.state.isModalOpen && (
          <PinModal
            graphTitle={graphTitle}
            onApply={this.onModalApply}
            onCancel={this.onModalCancel}
          />
        )}
      </div>
    );
  }
}

PinButton.propTypes = {
  historyId: PropTypes.string,
  graphTitle: PropTypes.string.isRequired,
  pinPage: PropTypes.func.isRequired,
  unpinPage: PropTypes.func.isRequired,
};

PinButton.defaultProps = {
  historyId: '',
};

export default PinButton;
