/* eslint-disable jsx-a11y/no-autofocus,jsx-a11y/label-has-associated-control */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Modal from '../../../../../components/Modal';

class PinModal extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { title: props.graphTitle };
  }

  onPinClick = () => {
    this.props.onApply(this.state.title);
  };

  onTitleChange = (event) => {
    event.preventDefault();
    this.setState({ title: event.target.value });
  };

  render() {
    return (
      <Modal
        title="Pin"
        okTitle="Pin"
        onOk={this.onPinClick}
        onCancel={this.props.onCancel}
        isOpen
      >
        <div className="pin-form">
          <div className="form-group">
            <label htmlFor="title">Name</label>
            <input
              name="title"
              className="form-control"
              type="text"
              placeholder="Enter name"
              value={this.state.title}
              onChange={this.onTitleChange}
              autoFocus
            />
          </div>
        </div>
      </Modal>
    );
  }
}

PinModal.propTypes = {
  graphTitle: PropTypes.string.isRequired,
  onApply: PropTypes.func.isRequired,
  onCancel: PropTypes.func.isRequired,
};

export default PinModal;
