import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import UrlUtils from '../../../../../utils/url/UrlUtils';
import UserLinksBasic from '../../../../../utils/UserLinksBasic';
import BrowserUtils from '../../../../../utils/BrowserUtils';
import TimeSelector from './TimeSelector/TimeSelector';

class OldTimeBar extends PureComponent {
  onTimeRangeButtonClick = (event) => {
    event.preventDefault();
    const { dataset } = event.target;
    const navValue = dataset.navbutton;
    const navButton = this.props.navButtons[navValue];

    if (!navButton) {
      return;
    }

    const b = navButton.begin;
    const e = navButton.end;

    let url = BrowserUtils.getLogicalUrlAfterHost();
    url = UrlUtils.removeQueryArgs(url, UserLinksBasic.B_QA, UserLinksBasic.E_QA);

    if (b != null) {
      url = UrlUtils.addParameter(url, UserLinksBasic.B_QA, b);
    }
    if (e != null) {
      url = UrlUtils.addParameter(url, UserLinksBasic.E_QA, e);
    }

    this.context.router.history.push(url);
  };

  onTimeRangeChange = (timeRange) => {
    let hashUrl = BrowserUtils.getLogicalUrlAfterHost();
    hashUrl = UrlUtils.updateParameter(hashUrl, UserLinksBasic.B_QA, timeRange.b);
    hashUrl = UrlUtils.updateParameter(hashUrl, UserLinksBasic.E_QA, timeRange.e);
    this.context.router.history.push(hashUrl);
  };

  renderNavButton(navValue, navTitle, autorefreshMod = '') {
    const navButton = this.props.navButtons[navValue];

    if (!navButton) {
      return null;
    }

    const { selected } = navButton;

    const className = `btn ${selected ? 'btn-primary' : 'btn-default'}`;

    return (
      <button
        type="button"
        className={className}
        data-navbutton={navValue}
        data-autorefresh={autorefreshMod}
        onClick={this.onTimeRangeButtonClick}
      >
        {navTitle}
      </button>
    );
  }

  render() {
    return (
      <div className="btn-toolbar">
        <div className="btn-group">
          <div className="btn btn-none">
            <TimeSelector
              timeRange={this.props.timeRange}
              onChange={this.onTimeRangeChange}
            />
          </div>
        </div>
        {this.renderNavButton('scrollNow', 'Now', 'add')}
        <div className="btn-group">
          {this.renderNavButton('fastBackward', '＜＜', 'remove')}
          {this.renderNavButton('fastForward', '＞＞', 'remove')}
        </div>
        <div className="btn-group">
          {this.renderNavButton('zoomIn', '＋', 'remove')}
          {this.renderNavButton('zoomOut', '－', 'remove')}
        </div>
        <div className="btn-group">
          {this.renderNavButton('zoom1h', 'Hour')}
          {this.renderNavButton('zoom1d', 'Day')}
          {this.renderNavButton('zoom1w', 'Week')}
          {this.renderNavButton('zoom1m', 'Month')}
          {this.renderNavButton('zoom1y', 'Year')}
        </div>
      </div>
    );
  }
}

OldTimeBar.propTypes = {
  navButtons: PropTypes.object.isRequired,
  timeRange: PropTypes.object.isRequired,
};

OldTimeBar.contextTypes = {
  router: PropTypes.shape({
    history: PropTypes.object.isRequired,
  }).isRequired,
};

export default OldTimeBar;
