/* eslint-disable jsx-a11y/no-static-element-interactions,jsx-a11y/click-events-have-key-events */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import TimeFormatUtils from '../../../../../../utils/time/TimeFormatUtils';
import TimeSelectorModal from './TimeSelectorModal';

import './style.css';

class TimeSelector extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { isOpen: false };
  }

  onShow = () => {
    this.setState({ isOpen: true });
  };

  onHide = () => {
    this.setState({ isOpen: false });
  };

  onApply = (newTimeRange) => {
    this.setState({ isOpen: false }, () => {
      this.props.onChange(newTimeRange);
    });
  };

  render() {
    const { timeRange } = this.props;

    const beginDate = new Date(timeRange.begin.epochSeconds * 1000);
    const endDate = new Date(timeRange.end.epochSeconds * 1000);

    const beginDateStr = TimeFormatUtils.dateToShortDateInLocalTz(beginDate);
    const endDateStr = TimeFormatUtils.dateToShortDateInLocalTz(endDate);

    const beginDateTimeStr = TimeFormatUtils.dateToShortDateTimeInLocalTz(beginDate);
    const endDateTimeStr = TimeFormatUtils.dateToShortDateTimeInLocalTz(endDate);

    return (
      <div>
        <span className="timeSelector2" onClick={this.onShow}>
          {beginDateStr}
          {' '}
          –
          {endDateStr}
        </span>
        <TimeSelectorModal
          beginDateTime={beginDateTimeStr}
          endDateTime={endDateTimeStr}
          isOpen={this.state.isOpen}
          onApply={this.onApply}
          onCancel={this.onHide}
        />
      </div>
    );
  }
}

TimeSelector.propTypes = {
  timeRange: PropTypes.object.isRequired,
  onChange: PropTypes.func.isRequired,
};

export default TimeSelector;
