/* eslint-disable jsx-a11y/no-autofocus */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import ReactModal from 'react-modal';
import TimeFormatUtils from '../../../../../../utils/time/TimeFormatUtils';

class TimeSelectorModal extends PureComponent {
  static mapPropsToState(props) {
    return { text: `${props.beginDateTime} - ${props.endDateTime}` };
  }

  constructor(props) {
    super(props);
    this.state = TimeSelectorModal.mapPropsToState(props);
  }

  componentDidUpdate(prevProps) {
    if (this.props.beginDateTime !== prevProps.beginDateTime
      || this.props.endDateTime !== prevProps.endDateTime) {
      this.setState(TimeSelectorModal.mapPropsToState(this.props));
    }
  }

  onChange = (event) => {
    event.preventDefault();
    this.setState({ text: event.target.value });
  };

  onGoClick = (event) => {
    event.preventDefault();

    const value = this.state.text;

    const parts = value.split(' - ');
    const b = parts[0];
    const e = parts[1];

    const params = {
      b: TimeFormatUtils.utcDateOfDefault(b),
      e: TimeFormatUtils.utcDateOfDefault(e),
    };

    this.props.onApply(params);
  };

  render() {
    return (
      <ReactModal
        className="modal-dialog"
        isOpen={this.props.isOpen}
        onRequestClose={this.props.onCancel}
        parentSelector={() => document.querySelector('#root')}
      >
        <div className="modal-content">
          <div className="modal-body">
            <form onSubmit={this.onGoClick}>
              <div className="row" style={{ verticalAlign: 'bottom' }}>
                <div className="col-xs-10">
                  <input
                    className="form-control"
                    type="text"
                    style={{ width: '100%' }}
                    value={this.state.text}
                    onChange={this.onChange}
                    autoFocus
                  />
                </div>
                <div className="col-xs-2">
                  <button
                    type="button"
                    className="btn btn-default"
                    onClick={this.onGoClick}
                  >
                    Go
                  </button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </ReactModal>
    );
  }
}

TimeSelectorModal.propTypes = {
  beginDateTime: PropTypes.string.isRequired,
  endDateTime: PropTypes.string.isRequired,
  isOpen: PropTypes.bool.isRequired,
  onApply: PropTypes.func.isRequired,
  onCancel: PropTypes.func.isRequired,
};

export default TimeSelectorModal;
