import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

class ErrorBlock extends PureComponent {
  render() {
    const { error } = this.props;

    return (
      <div>
        <h3 className="text-danger">Error</h3>
        {error.message && (
          <p>
            <code style={{ whiteSpace: 'normal' }}>{error.message}</code>
          </p>
        )}
      </div>
    );
  }
}

ErrorBlock.propTypes = {
  error: PropTypes.object.isRequired,
};

export default ErrorBlock;
