import React, { Fragment } from 'react';
import PropTypes from 'prop-types';

const NoncriticalAlert = ({ alert }) => (
  <div className={alert.alarm ? 'alert alert-danger' : 'alert alert-warning'}>
    {alert.text}
    {alert.altLink ? (
      <>
        , try
        {' '}
        <a href={alert.altLink}>this</a>
      </>
    ) : null}
  </div>
);

NoncriticalAlert.propTypes = {
  alert: PropTypes.object.isRequired,
};

export default NoncriticalAlert;
