import BrowserUtils from '../../../../utils/BrowserUtils';
import UserLinksBasic from '../../../../utils/UserLinksBasic';

class OldSelectorUtils {
  static formatSelectorsOrEmpty(selectors) {
    const filteredSelectors = OldSelectorUtils.filterSelectors(selectors);

    const hasSelectors = filteredSelectors.length > 0;

    if (hasSelectors) {
      const project = BrowserUtils.getLogicalQueryArgOrEmpty(UserLinksBasic.PROJECT);
      return OldSelectorUtils.formatSelectors(project, filteredSelectors);
    }

    return '';
  }

  static filterSelectors(selectors) {
    return selectors.filter((selector) => {
      const { name } = selector;
      return name !== 'graph' && name !== 'dashboard' && selector.value;
    });
  }

  static formatSelectors(project, selectors) {
    const formattedSelectorsList = [];

    formattedSelectorsList.push(`project="${project}"`);

    for (let i = 0; i < selectors.length; ++i) {
      const selector = selectors[i];

      const { name } = selector;
      let { value } = selector;

      if (!value) {
        value = OldSelectorUtils.getSelectedValueFromOptions(selector);
      }

      let newSelector = name.includes('-') ? OldSelectorUtils.quoteValue(name) : name;

      if (value.startsWith('!')) {
        newSelector += `!=${OldSelectorUtils.quoteValue(value.substring(1))}`;
      } else {
        newSelector += `=${OldSelectorUtils.quoteValue(value)}`;
      }

      formattedSelectorsList.push(newSelector);
    }

    return formattedSelectorsList.join(', ');
  }

  static getSelectedValueFromOptions(selector) {
    for (let j = 0; j < selector.options.length; ++j) {
      const option = selector.options[j];
      if (option.selected) {
        return option.value;
      }
    }

    return '';
  }

  static quoteValue(value) {
    return `"${value.replace(/"/g, '\\"')}"`;
  }
}

export default OldSelectorUtils;
