import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';

import OldSelector from './OldSelector';
import OldSelectorUtils from './OldSelectorUtils';
import CopyButton from '../../../../components/CopyButton/CopyButton';

import {
  clearSelectorValues,
  getSelectorValues,
} from '../../../../store/reducers/old/oldSelectors';
import BrowserUtils from '../../../../utils/BrowserUtils';
import LastPlusSelector from './LastPlusSelector';
import {
  changeLabelFilter,
  hideLabelsDropdown, selectLabel,
  showLabelsDropdown,
} from '../../../../store/reducers/old/oldLastPlusSelector';

class OldSelectors extends PureComponent {
  componentWillUnmount() {
    this.props.hideLabelsDropdown();
    this.props.clearSelectorValues();
  }

  render() {
    const { selectors } = this.props;
    const formattedSelectors = OldSelectorUtils.formatSelectorsOrEmpty(selectors);

    let copyButton = null;

    if (formattedSelectors) {
      copyButton = (
        <CopyButton value={formattedSelectors} />
      );
    }

    let newButton = null;

    const graphParam = BrowserUtils.getLogicalQueryArgOrEmpty('graph');
    const dashParam = BrowserUtils.getLogicalQueryArgOrEmpty('dashboard');
    const isAutoGraphOrSensorsPage = graphParam === 'auto'
      || (graphParam === '' && dashParam === '');

    if (isAutoGraphOrSensorsPage) {
      newButton = (
        <LastPlusSelector
          search={window.location.search}
          lastPlusSelector={this.props.lastPlusSelector}
          onShowLabelsDropdown={this.props.showLabelsDropdown}
          onHideLabelsDropdown={this.props.hideLabelsDropdown}
          onChangeLabelFilter={this.props.changeLabelFilter}
          onSelectLabel={this.props.selectLabel}
          loadedSelectorsValues={this.props.loadedSelectorsValues}
          showAllValuesInSelectors={this.props.showAllValuesInSelectors}
          getSelectorValues={this.props.getSelectorValues}
        />
      );
    }

    return (
      <div className="selectors-placeholder">
        {selectors.map((s) => (
          <OldSelector
            key={s.name}
            selector={s}
            selectorValues={this.props.loadedSelectorsValues[s.name]}
            showAllValues={this.props.showAllValuesInSelectors}
            getSelectorValues={this.props.getSelectorValues}
          />
        ))}
        {newButton}
        {copyButton}
      </div>
    );
  }
}

OldSelectors.propTypes = {
  selectors: PropTypes.array.isRequired,
  showAllValuesInSelectors: PropTypes.bool.isRequired,
  loadedSelectorsValues: PropTypes.object.isRequired,
  getSelectorValues: PropTypes.func.isRequired,
  clearSelectorValues: PropTypes.func.isRequired,
  // Label keys props
  lastPlusSelector: PropTypes.object.isRequired,
  showLabelsDropdown: PropTypes.func.isRequired,
  hideLabelsDropdown: PropTypes.func.isRequired,
  changeLabelFilter: PropTypes.func.isRequired,
  selectLabel: PropTypes.func.isRequired,
};

const mapStateToProps = (state) => ({
  // Selector values
  loadedSelectorsValues: state.oldSelectors,
  // Label keys
  lastPlusSelector: state.oldLastPlusSelector,
  showAllValuesInSelectors: state.userSettings.data
    && state.userSettings.data.settings.showAllValuesInSelectors === 'true',
});

const mapDispatchToProps = (dispatch) => bindActionCreators({
  getSelectorValues,
  clearSelectorValues,
  showLabelsDropdown,
  hideLabelsDropdown,
  changeLabelFilter,
  selectLabel,
}, dispatch);

export default connect(mapStateToProps, mapDispatchToProps)(OldSelectors);
