import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

import UserLinksBasic from '../../../../utils/UserLinksBasic';

import './style.css';

class PinsBlock extends PureComponent {
  handleDelete = (id) => {
    this.props.onDelete(id);
  };

  render() {
    const { pins } = this.props;

    if (pins.length === 0) {
      return null;
    }

    const mainElement = (
      <ul className="pins-block__list">
        {pins.map((pin) => (
          <li key={pin.id}>
            <Link to={UserLinksBasic.fixOldAdminUrl(pin.url)}>{pin.title}</Link>
            <span
              role="presentation"
              className="pins-block__unpin-btn"
              onClick={() => this.handleDelete(pin.id)}
            >
              &times;
            </span>
          </li>
        ))}
      </ul>
    );

    return (
      <div className="pins-block">
        <h4>Pinned</h4>
        {mainElement}
      </div>
    );
  }
}

PinsBlock.propTypes = {
  pins: PropTypes.array.isRequired,
  onDelete: PropTypes.func.isRequired,
};

export default PinsBlock;
