/* eslint-disable react/no-danger */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { highlightLinks, escapeHtml } from '../../utils/TemplateUtils';

import './style.css';

class TitleWithDescription extends PureComponent {
  componentDidMount() {
    this.makeElipsisDescriptionIfNeeded();
  }

  makeElipsisDescriptionIfNeeded() {
    const descriptionWidth = this.$desc.clientWidth;
    const titleWidth = this.$title.clientWidth;

    const isWide = (descriptionWidth + titleWidth) > this.$titleAndDesc.clientWidth;

    if (this.props.description.indexOf('\n') >= 0 || isWide) {
      this.$titleAndDesc.classList.add('ellipsis');

      this.$desc.addEventListener('click', () => {
        this.$desc.classList.toggle('graphDescription-expanded');
      });
      this.$desc.style.cursor = 'pointer';

      const $links = this.$desc.querySelectorAll('a');
      $links.forEach(($link) => {
        $link.addEventListener('click', (event) => event.stopPropagation());
        $link.setAttribute('target', '_blank');
      });
    }
  }

  render() {
    const { title, description } = this.props;

    let descriptionHtml = '';

    if (description) {
      descriptionHtml = highlightLinks(escapeHtml(description));
    }

    return (
      <h3
        className="titleAndDescription"
        style={{ whiteSpace: 'nowrap' }}
        ref={(el) => { this.$titleAndDesc = el; }}
      >
        <span className="title-placeholder" ref={(el) => { this.$title = el; }}>
          {title}
        </span>
        <small
          className="description-placeholder"
          style={{ marginLeft: '7px' }}
          dangerouslySetInnerHTML={{ __html: descriptionHtml }}
          ref={(el) => { this.$desc = el; }}
        />
      </h3>
    );
  }
}

TitleWithDescription.propTypes = {
  title: PropTypes.string.isRequired,
  description: PropTypes.string,
};

TitleWithDescription.defaultProps = {
  description: '',
};

export default TitleWithDescription;
