import React from 'react';
import PropTypes from 'prop-types';
import NoncriticalAlert from './NoncriticalAlert';

const TopLevelGraphAlerts = ({ alerts }) => (
  <div className="noncriticalAlert-placeholder">
    {alerts.map((alert) => (
      <NoncriticalAlert key={alert.key || 'noncritical_error'} alert={alert} />
    ))}
  </div>
);

TopLevelGraphAlerts.propTypes = {
  alerts: PropTypes.array.isRequired,
};

export default TopLevelGraphAlerts;
