export function escapeHtml(text) {
  return `${text}`.replace(/</g, '&lt;').replace(/>/g, '&gt;');
}

export function unquote(text) {
  return `${text}`.replace(/"/g, '&quot;');
}

export function highlightLinks(text) {
  return text.replace(/( |\n|^)(https?:\/\/[^ \n]+)( |\n|$)/g, '$1<a href="$2">$2</a>$3');
}

export default {};
