import BrowserUtils from '../../../utils/BrowserUtils';
import UrlUtils from '../../../utils/url/UrlUtils';
import { createConfiguredGraphOrDashboardUrl, createExplorerUrl } from './graphToExpressionTransformations';
import * as GraphAPI from '../../../api/graphs';
import * as DashboardAPI from '../../../api/dashboards';
import { isPreOrProdIntEnv } from '../../../utils/env';

function redirectToNewUi(isText) {
  if (!isPreOrProdIntEnv()) {
    return false;
  }

  const urlParsed = UrlUtils.parseUrl(BrowserUtils.getLogicalUrlAfterHost());

  const project = urlParsed.getLogicalQueryArgOrEmpty('project');

  const graphParam = urlParsed.getLogicalQueryArgOrEmpty('graph');
  const dashboardParam = urlParsed.getLogicalQueryArgOrEmpty('dashboard');

  if (graphParam === 'auto') {
    const newUrl = createExplorerUrl(isText);

    if (newUrl) {
      window.location.replace(newUrl);
      return true;
    }
    return false;
  }

  let promise = null;

  if (graphParam) {
    promise = GraphAPI.fetchGraph(project, graphParam);
  } else if (dashboardParam) {
    promise = DashboardAPI.fetchDashboard(project, dashboardParam);
  } else {
    return false;
  }

  return promise.then((graphOrDashboard) => {
    const genId = graphOrDashboard.generatedId;
    const newUrl = createConfiguredGraphOrDashboardUrl(genId);
    if (newUrl) {
      window.location.replace(newUrl);
      return true;
    }
    return false;
  });
}

export default redirectToNewUi;
