import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';

import {
  deleteFavoriteProject,
  saveFavoriteProject,
} from '../../store/reducers/projects/favoriteProjects';

import './FavoriteProjectToggler.css';

class FavoriteProjectToggler extends PureComponent {
  onSave = () => {
    this.props.saveFavoriteProject(this.props.projectId);
  };

  onDelete = () => {
    this.props.deleteFavoriteProject(this.props.projectId);
  };

  render() {
    const { projectId, favoriteProjectIds } = this.props;

    const isFavorite = favoriteProjectIds.indexOf(projectId) >= 0;

    return (
      <i
        className={`glyphicon glyphicon-star${isFavorite ? '' : '-empty'} favorite-project-toggler`}
        onClick={isFavorite ? this.onDelete : this.onSave}
      />
    );
  }
}

FavoriteProjectToggler.propTypes = {
  projectId: PropTypes.string.isRequired,
  favoriteProjectIds: PropTypes.array.isRequired,
  saveFavoriteProject: PropTypes.func.isRequired,
  deleteFavoriteProject: PropTypes.func.isRequired,
};

const mapStateToProps = (state) => ({
  favoriteProjectIds: state.favoriteProjects.ids,
});

const mapDispatchToProps = (dispatch) => bindActionCreators({
  saveFavoriteProject,
  deleteFavoriteProject,
}, dispatch);

export default connect(mapStateToProps, mapDispatchToProps)(FavoriteProjectToggler);
