/* eslint-disable max-classes-per-file */

import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import TableViewer from '../../components/TableViewer';
import UserName from '../../components/UserName';

const ACL_ENTRY_SHAPE = PropTypes.shape({
  name: PropTypes.string,
  uid: PropTypes.string,
  uidType: PropTypes.string,
  role: PropTypes.arrayOf(PropTypes.string),
});

const IDM_ACL_ENTRY_PERMISSIONS = {
  VIEWER: { value: 'ROLE_VIEWER', title: 'Viewer' },
  EDITOR: { value: 'ROLE_EDITOR', title: 'Editor' },
  PUSHER: { value: 'ROLE_PUSHER', title: 'Pusher' },
  MUTER: { value: 'ROLE_MUTER', title: 'Muter' },
  ADMIN: { value: 'ROLE_ADMIN', title: 'Admin' },
};
const PERMISSION_TITLES = Object.keys(IDM_ACL_ENTRY_PERMISSIONS)
  .map((key) => IDM_ACL_ENTRY_PERMISSIONS[key].title);

const PERMISSION_VALUES = Object.keys(IDM_ACL_ENTRY_PERMISSIONS)
  .map((key) => IDM_ACL_ENTRY_PERMISSIONS[key].value);

const checkbox = (checked) => (
  checked && (<span className="glyphicon glyphicon-ok" />)
);

class ReadonlyRow extends PureComponent {
  renderSubject = ({ uidType, name, uid }) => {
    switch (uidType) {
      case 'UID_TYPE_TVM': {
        return (
          <span>{`tvm-${name}`}</span>
        );
      }
      case 'UID_TYPE_USER': {
        return <UserName login={uid} />;
      }
      case 'UID_TYPE_SERVICE':
      case 'UID_TYPE_GROUP': {
        return (
          <span>{name}</span>
        );
      }
      default: {
        return null;
      }
    }
  }

  render() {
    const { index, value } = this.props;

    return (
      <tr>
        <td>{index + 1}</td>
        <td>{this.renderSubject(value)}</td>
        {PERMISSION_VALUES.map((permission) => (
          <td key={`PERMISSION_${permission}`}>
            {checkbox(value.role.indexOf(permission) >= 0)}
          </td>
        ))}
      </tr>
    );
  }
}

ReadonlyRow.propTypes = {
  index: PropTypes.number.isRequired,
  value: ACL_ENTRY_SHAPE.isRequired,
};

const ReadonlyTable = ({ roles, limit }) => (
  <TableViewer
    columns={['#', 'User', ...PERMISSION_TITLES]}
    values={roles}
    row={ReadonlyRow}
    limit={limit}
  />
);

ReadonlyTable.propTypes = {
  roles: PropTypes.arrayOf(ACL_ENTRY_SHAPE),
  limit: PropTypes.number.isRequired,
};

ReadonlyTable.defaultProps = {
  roles: [],
};

export default ReadonlyTable;
