import React from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';

const ProjectBlock = ({ id, name, path }) => (
  <div className="project-block">
    <Link
      className="project-block__name"
      to={path}
    >
      {name}
    </Link>
    <small className="project-block__id">{id}</small>
  </div>
);

ProjectBlock.propTypes = {
  id: PropTypes.string.isRequired,
  name: PropTypes.string.isRequired,
  path: PropTypes.oneOfType([PropTypes.string, PropTypes.object]).isRequired,
};

export default ProjectBlock;
