import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import ProjectBlock from './ProjectBlock';
import Pagination from '../../components/Pagination';

function makeProjectPathInternal(projectId, isAdmin, makeProjectPath) {
  if (makeProjectPath !== undefined) {
    return makeProjectPath(projectId);
  }
  if (isAdmin) {
    return `/admin/projects/${projectId}`;
  }
  return `/?project=${projectId}`;
}

export default class ProjectsBlock extends PureComponent {
  render() {
    const {
      projectsPage, favoriteProjects, isAdmin, text,
    } = this.props;
    const projects = projectsPage.result || [];
    const pagination = projectsPage.page;
    const hasFavoriteProjects = favoriteProjects.length > 0;

    let filteredFavoriteProjects;

    if (text) {
      filteredFavoriteProjects = favoriteProjects.filter((p) =>
        p.id.indexOf(text) >= 0 || p.name.indexOf(text) >= 0);
    } else {
      filteredFavoriteProjects = favoriteProjects;
    }

    return (
      <>
        {hasFavoriteProjects && filteredFavoriteProjects.length > 0 && (
          <div className="projects-block">
            <h3>
              Favorite projects
            </h3>
            <div className="projects-container">
              {filteredFavoriteProjects.map((p) => (
                <ProjectBlock
                  key={p.id}
                  id={p.id}
                  name={p.name}
                  path={makeProjectPathInternal(p.id, isAdmin, this.props.makeProjectPath)}
                />
              ))}
            </div>
          </div>
        )}
        {projects.length > 0 && (
          <div className="projects-block">
            {hasFavoriteProjects && (
              <h3>
                All projects
              </h3>
            )}
            <div className="projects-container">
              {projects.map((p) => (
                <ProjectBlock
                  key={p.id}
                  id={p.id}
                  name={p.name}
                  path={makeProjectPathInternal(p.id, isAdmin, this.props.makeProjectPath)}
                />
              ))}
            </div>
          </div>
        )}
        {pagination && (
          <Pagination
            activePage={pagination.current + 1}
            pageCount={pagination.pagesCount}
            pageSize={pagination.pageSize}
            totalCount={pagination.totalCount}
            onActivePageChange={this.props.onActivePageChange}
            onPageSizeChange={this.props.onPageSizeChange}
          />
        )}
      </>
    );
  }
}

ProjectsBlock.propTypes = {
  projectsPage: PropTypes.object.isRequired,
  favoriteProjects: PropTypes.array.isRequired,
  text: PropTypes.string.isRequired,
  isAdmin: PropTypes.bool.isRequired,
  onActivePageChange: PropTypes.func.isRequired,
  onPageSizeChange: PropTypes.func.isRequired,
  makeProjectPath: PropTypes.func.isRequired,
};
