import React from 'react';
import PropTypes from 'prop-types';

import UserName from '../../../components/UserName';
import WarningAlert from './WarningAlert';

const PermissionAlert = ({ message, owner }) => {
  const messageWithOwner = (
    <p>
      {message}
      <br />
      You can send to
      {' '}
      <UserName login={owner} />
      {' '}
      to request project permissions
    </p>
  );

  return <WarningAlert title="Permission denied!" message={messageWithOwner} />;
};

PermissionAlert.propTypes = {
  message: PropTypes.oneOfType([PropTypes.string, PropTypes.element]).isRequired,
  owner: PropTypes.string.isRequired,
};

export default PermissionAlert;
