import React from 'react';
import PropTypes from 'prop-types';

import './style.css';

const WarningAlert = ({ title, message, type }) => (
  <div className="warning-alert">
    <div className={`alert alert-${type}`}>
      <p>
        <strong>
          <i className="glyphicon glyphicon-alert" />
          {' '}
          {title}
        </strong>
      </p>
      {message}
    </div>
  </div>
);

WarningAlert.propTypes = {
  title: PropTypes.string.isRequired,
  message: PropTypes.oneOfType([PropTypes.string, PropTypes.element]).isRequired,
  type: PropTypes.string,
};

WarningAlert.defaultProps = {
  type: 'danger',
};

export default WarningAlert;
